package ru.yandex.direct.balance.client.model.request;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
public class ModulusReminderRequest extends SelfMappedBalanceRpcRequest {
    private int modulus;
    private int reminder;

    @JsonProperty("Mod")
    public int getModulus() {
        return modulus;
    }

    public void setModulus(int modulus) {
        this.modulus = modulus;
    }

    @JsonProperty("Rem")
    public int getReminder() {
        return reminder;
    }

    public void setReminder(int reminder) {
        this.reminder = reminder;
    }

    public ModulusReminderRequest withModulus(int modulus) {
        this.modulus = modulus;
        return this;
    }

    public ModulusReminderRequest withReminder(int reminder) {
        this.reminder = reminder;
        return this;
    }
}
