package ru.yandex.direct.balance.client.model.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Запрос для инициализации оплаты
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.payrequest
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PayRequestRequest extends BalanceRpcRequestParam {

    @JsonIgnore
    private Long operatorUid;

    @JsonProperty("RequestID")
    private String requestId;

    @JsonProperty("PaymentMethodID")
    private String paymentMethodId;

    @JsonProperty("Currency")
    private String currency;

    @JsonProperty("PersonID")
    private String personId;

    @JsonProperty("RedirectURL")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String redirectUrl;

    @JsonProperty("Payload")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String getPayload() {
        return "{\"template\":\"checkout\"}";
    }

    public PayRequestRequest withOperatorUid(Long operatorUid) {
        this.operatorUid = operatorUid;
        return this;
    }

    public PayRequestRequest withRequestId(Long requestId) {
        this.requestId = requestId.toString();
        return this;
    }

    public PayRequestRequest withPaymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
        return this;
    }

    public PayRequestRequest withCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public PayRequestRequest withPersonId(Long personId) {
        this.personId = personId.toString();
        return this;
    }

    public PayRequestRequest withRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    @Override
    public Object[] asArray() {
        return new Object[]{operatorUid.toString(), objectToMap(this)};
    }
}


