package ru.yandex.direct.balance.client.model.request;

import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import static java.util.stream.Collectors.toList;

/**
 * Запрос для передачи в биллинг ограниченных представителей агентств и клиентов, к которым они имеют доступ
 * <p>
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.createuserclientassociation
 */
@ParametersAreNonnullByDefault
public class SetAgencyLimitedRepSubclientsRequest extends CreateUserClientAssociationRequest {
    private List<String> subclientIds;

    public List<String> getSubclientIds() {
        return subclientIds;
    }

    public void setSubclientIds(List<Long> subclientIds) {
        this.subclientIds = subclientIds.stream()
                .filter(Objects::nonNull)
                .map(Object::toString)
                .collect(toList());
    }

    public SetAgencyLimitedRepSubclientsRequest withSubclientIds(List<Long> subclientIds) {
        setSubclientIds(subclientIds);
        return this;
    }

    @Override
    public Object[] asArray() {
        // id клиентов должны быть уникальными, чтобы не было ошибки при вызове Баланса
        Object[] uniqueSubclientIds = subclientIds.stream().distinct().toArray();

        return new Object[]{
                this.getOperatorUid(),
                this.getClientId(),
                this.getRepresentativeUid(),
                uniqueSubclientIds};
    }
}
