package ru.yandex.direct.balance.client.model.request;

import java.math.BigDecimal;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.primitives.Ints;

/**
 * Запрос на изменение лимита овердрафта ОС клиента
 */
@ParametersAreNonnullByDefault
public class SetOverdraftParamsRequest extends SelfMappedBalanceRpcRequest {
    @JsonProperty("PersonID")
    private Integer personId;
    @JsonProperty("ServiceID")
    private Integer serviceId;
    @JsonProperty("PaymentMethodCC")
    private String paymentMethodCode;
    @JsonProperty("Currency")
    private String isoCurrencyCode;
    @JsonProperty("ClientLimit")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal clientLimit;

    public Integer getPersonId() {
        return personId;
    }

    public SetOverdraftParamsRequest withPersonId(Long personId) {
        this.personId = Ints.checkedCast(personId);
        return this;
    }

    public Integer getServiceId() {
        return serviceId;
    }

    public SetOverdraftParamsRequest withServiceId(Integer serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public String getPaymentMethodCode() {
        return paymentMethodCode;
    }

    public SetOverdraftParamsRequest withPaymentMethodCode(String paymentMethodCode) {
        this.paymentMethodCode = paymentMethodCode;
        return this;
    }

    public String getIsoCurrencyCode() {
        return isoCurrencyCode;
    }

    public SetOverdraftParamsRequest withIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    public BigDecimal getClientLimit() {
        return clientLimit;
    }

    public SetOverdraftParamsRequest withClientLimit(BigDecimal clientLimit) {
        this.clientLimit = clientLimit;
        return this;
    }
}
