package ru.yandex.direct.balance.client.model.request;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.primitives.Ints;


/**
 * Запрос для отзыва промокода.
 *
 * @see <a href="https://st.yandex-team.ru/BALANCE-28045#1526890733000">Описание параметров</a>
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class TearOffPromocodeRequest extends BalanceRpcRequestParam {

    @JsonIgnore
    private String operatorUid;

    @JsonProperty("InvoiceID")
    private Integer invoiceId;

    @JsonProperty("InvoiceEID")
    private String invoiceExternalId;

    @JsonProperty("ClientID")
    private String clientId;

    @JsonProperty("ServiceID")
    private Integer serviceId;

    @JsonProperty("ServiceOrderID")
    private Integer serviceOrderId;

    @JsonProperty("PromocodeID")
    private Integer promocodeId;

    @JsonProperty("Promocode")
    private String promocode;

    @Override
    public Object[] asArray() {
        return new Object[]{operatorUid, objectToMap(this)};
    }

    public TearOffPromocodeRequest withOperatorUid(@Nullable Long operatorUid) {
        this.operatorUid = operatorUid == null ? null : operatorUid.toString();
        return this;
    }

    public TearOffPromocodeRequest withInvoiceId(Long invoiceId) {
        this.invoiceId = invoiceId != null ? Ints.checkedCast(invoiceId) : null;
        return this;
    }

    public TearOffPromocodeRequest withInvoiceExternalId(String invoiceExternalId) {
        this.invoiceExternalId = invoiceExternalId;
        return this;
    }

    public TearOffPromocodeRequest withClientId(@Nullable Long clientId) {
        this.clientId = clientId == null ? null : clientId.toString();
        return this;
    }

    public TearOffPromocodeRequest withServiceId(Integer serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public TearOffPromocodeRequest withServiceOrderId(Long serviceOrderId) {
        this.serviceOrderId = serviceOrderId != null ? Ints.checkedCast(serviceOrderId) : null;
        return this;
    }

    public TearOffPromocodeRequest withPromocodeId(Long promocodeId) {
        this.promocodeId = promocodeId != null ? Ints.checkedCast(promocodeId) : null;
        return this;
    }

    public TearOffPromocodeRequest withPromocode(String promocode) {
        this.promocode = promocode;
        return this;
    }

    public String getOperatorUid() {
        return operatorUid;
    }

    public Integer getInvoiceId() {
        return invoiceId;
    }

    public String getInvoiceExternalId() {
        return invoiceExternalId;
    }

    public String getClientId() {
        return clientId;
    }

    public Integer getServiceId() {
        return serviceId;
    }

    public Integer getServiceOrderId() {
        return serviceOrderId;
    }

    public Integer getPromocodeId() {
        return promocodeId;
    }

    public String getPromocode() {
        return promocode;
    }
}
