package ru.yandex.direct.balance.client.model.request.createtransfermultiple;

import java.util.List;

import ru.yandex.direct.balance.client.model.request.BalanceRpcRequestParam;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class CreateTransferMultipleRequest extends BalanceRpcRequestParam {

    private String operatorUid;

    private List<TransferTargetFrom> transferTargetsFrom;

    private List<TransferTargetTo> transferTargetsTo;

    public CreateTransferMultipleRequest withOperatorUid(Long operatorUid) {
        this.operatorUid = operatorUid.toString();
        return this;
    }

    public CreateTransferMultipleRequest withTransferTargetsFrom(List<TransferTargetFrom> transferTargetsFrom) {
        this.transferTargetsFrom = transferTargetsFrom;
        return this;
    }

    public CreateTransferMultipleRequest withTransferTargetsTo(List<TransferTargetTo> transferTargetsTo) {
        this.transferTargetsTo = transferTargetsTo;
        return this;
    }

    @Override
    public Object[] asArray() {
        return new Object[]{
                operatorUid,
                mapList(transferTargetsFrom, this::objectToMap),
                mapList(transferTargetsTo, this::objectToMap)};
    }
}
