package ru.yandex.direct.balance.client.model.request.createtransfermultiple;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class TransferTargetFrom extends TransferTarget<TransferTargetFrom> {

    @JsonProperty("QtyOld")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal qtyOld;

    @JsonProperty("QtyNew")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal qtyNew;

    public TransferTargetFrom withQtyOld(BigDecimal qtyOld) {
        this.qtyOld = qtyOld;
        return this;
    }

    public TransferTargetFrom withQtyNew(BigDecimal qtyNew) {
        this.qtyNew = qtyNew;
        return this;
    }
}
