package ru.yandex.direct.balance.client.model.request.createtransfermultiple;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class TransferTargetTo extends TransferTarget<TransferTargetTo> {

    @JsonProperty("QtyDelta")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal qtyDelta;

    public TransferTargetTo withQtyDelta(BigDecimal qtyDelta) {
        this.qtyDelta = qtyDelta;
        return this;
    }
}
