package ru.yandex.direct.balance.client.model.response;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Класс для описания тела ответа методов XML-RPC API баланса, которые возвращают результат в виде кортежа (0, "SUCCESS", Object)
 */
@ParametersAreNonnullByDefault
public class BalanceExtendedStatusResponse<R> extends BalanceSimpleStatusResponse {
    private R data;

    public BalanceExtendedStatusResponse(int status, String message) {
        super(status, message);
    }

    public R getData() {
        return data;
    }

    public void setData(R data) {
        this.data = data;
    }

    public BalanceExtendedStatusResponse withData(R data) {
        this.data = data;
        return this;
    }
}
