package ru.yandex.direct.balance.client.model.response;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Класс для описания тела ответа методов XML-RPC API баланса, которые возвращают результат в виде кортежа (0, "SUCCESS")
 */
@ParametersAreNonnullByDefault
public class BalanceSimpleStatusResponse extends BalanceRpcResponse {
    private final int status;
    private final String message;

    public BalanceSimpleStatusResponse(int status, String message) {
        this.status = status;
        this.message = message;
    }

    public int getStatus() {
        return status;
    }

    public String getMessage() {
        return message;
    }
}
