package ru.yandex.direct.balance.client.model.response;

import java.math.BigDecimal;
import java.time.LocalDate;

import javax.annotation.ParametersAreNonnullByDefault;

import com.univocity.parsers.annotations.Convert;
import com.univocity.parsers.annotations.Parsed;

import ru.yandex.direct.balance.client.converter.LocalDateConversion;

@ParametersAreNonnullByDefault
public class ClientNdsItem extends BalanceRpcResponse {
    @Parsed(field = "CLIENT_ID")
    private long clientId;

    @Parsed(field = "DT")
    @Convert(conversionClass = LocalDateConversion.class)
    private LocalDate dt;

    @Parsed(field = "NDS_PCT")
    private BigDecimal ndsPct;

    public long getClientId() {
        return clientId;
    }

    public void setClientId(long clientId) {
        this.clientId = clientId;
    }

    public ClientNdsItem withClientId(long clientId) {
        this.clientId = clientId;
        return this;
    }

    public LocalDate getDt() {
        return dt;
    }

    public void setDt(LocalDate dt) {
        this.dt = dt;
    }

    public ClientNdsItem withDt(LocalDate dt) {
        this.dt = dt;
        return this;
    }

    public BigDecimal getNdsPct() {
        return ndsPct;
    }

    public void setNdsPct(BigDecimal ndsPct) {
        this.ndsPct = ndsPct;
    }

    public ClientNdsItem withNdsPct(BigDecimal ndsPct) {
        this.ndsPct = ndsPct;
        return this;
    }
}
