package ru.yandex.direct.balance.client.model.response;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

import javax.annotation.ParametersAreNonnullByDefault;

import com.univocity.parsers.annotations.Convert;
import com.univocity.parsers.annotations.Parsed;

import ru.yandex.direct.balance.client.converter.LocalDateConversion;
import ru.yandex.direct.balance.client.converter.LocalDateTimeConversion;

@ParametersAreNonnullByDefault
public class DirectDiscountItem extends BalanceRpcResponse {
    @Parsed(field = "CLIENT_ID")
    private long clientId;

    @Parsed(field = "START_DT")
    @Convert(conversionClass = LocalDateConversion.class)
    private LocalDate startDt;

    @Parsed(field = "END_DT")
    @Convert(conversionClass = LocalDateConversion.class)
    private LocalDate endDt;

    @Parsed(field = "DISCOUNT")
    private BigDecimal discount;

    @Parsed(field = "UPDATE_DT")
    @Convert(conversionClass = LocalDateTimeConversion.class)
    private LocalDateTime updateDt;

    public long getClientId() {
        return clientId;
    }

    public void setClientId(long clientId) {
        this.clientId = clientId;
    }

    public DirectDiscountItem withClientId(long clientId) {
        this.clientId = clientId;
        return this;
    }

    public LocalDate getStartDt() {
        return startDt;
    }

    public void setStartDt(LocalDate startDt) {
        this.startDt = startDt;
    }

    public DirectDiscountItem withStartDt(LocalDate startDt) {
        this.startDt = startDt;
        return this;
    }

    public LocalDate getEndDt() {
        return endDt;
    }

    public void setEndDt(LocalDate endDt) {
        this.endDt = endDt;
    }

    public DirectDiscountItem withEndDt(LocalDate endDt) {
        this.endDt = endDt;
        return this;
    }

    public BigDecimal getDiscount() {
        return discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public DirectDiscountItem withDiscount(BigDecimal discount) {
        this.discount = discount;
        return this;
    }

    public LocalDateTime getUpdateDt() {
        return updateDt;
    }

    public void setUpdateDt(LocalDateTime updateDt) {
        this.updateDt = updateDt;
    }

    public DirectDiscountItem withUpdateDt(LocalDateTime updateDt) {
        this.updateDt = updateDt;
        return this;
    }
}
