package ru.yandex.direct.balance.client.model.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Один из элементов листа ответа функции Balance.FindClient
 * Сейчас используем не все доступные поля,
 * при необходимости более сложных запросов см. https://wiki.yandex-team.ru/Balance/XmlRpc/#balance.findclient
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class FindClientResponseItem extends BalanceRpcResponse {

    @JsonProperty("CLIENT_ID")
    private Long clientId;

    @JsonProperty("CLIENT_TYPE_ID")
    private Integer clientTypeId;

    @JsonProperty("IS_AGENCY")
    private Integer isAgency;

    @JsonProperty("AGENCY_ID")
    private Long agencyId;

    @JsonProperty("NAME")
    private String name;//имя клиента

    @JsonProperty("EMAIL")
    private String email; //E-mail клиента

    @JsonProperty("PHONE")
    private String phone;//телефон клиента

    @JsonProperty("FAX")
    private String fax; //факс

    @JsonProperty("URL") //URL клиента
    private String url;

    @JsonProperty("REGION_ID")
    private Long regionId;


    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public FindClientResponseItem withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Integer getClientTypeId() {
        return clientTypeId;
    }

    public void setClientTypeId(Integer clientTypeId) {
        this.clientTypeId = clientTypeId;
    }

    public FindClientResponseItem withClientTypeId(Integer clientTypeId) {
        this.clientTypeId = clientTypeId;
        return this;
    }

    public Integer getIsAgency() {
        return isAgency;
    }

    public void setIsAgency(Integer isAgency) {
        this.isAgency = isAgency;
    }

    public FindClientResponseItem withIsAgency(Integer isAgency) {
        this.isAgency = isAgency;
        return this;
    }

    public Long getAgencyId() {
        return agencyId;
    }

    public void setAgencyId(Long agencyId) {
        this.agencyId = agencyId;
    }

    public FindClientResponseItem withAgencyId(Long agencyId) {
        this.agencyId = clientId;
        return this;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FindClientResponseItem withName(String name) {
        this.name = name;
        return this;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public FindClientResponseItem withEmail(String email) {
        this.email = email;
        return this;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public FindClientResponseItem withPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public String getFax() {
        return fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public FindClientResponseItem withFax(String fax) {
        this.fax = fax;
        return this;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public FindClientResponseItem withUrl(String url) {
        this.url = url;
        return this;
    }

    public Long getRegionId() {
        return regionId;
    }

    public void setRegionId(Long regionId) {
        this.regionId = regionId;
    }

    public FindClientResponseItem withRegionId(Long regioId) {
        this.regionId = regioId;
        return this;
    }
}
