package ru.yandex.direct.balance.client.model.response;

/**
 * Результат поиска клиента функцией FindClientResult.findExistingClient
 */
public class FindClientResult {
    private FindClientResponseItem item;
    private FindClientStatus status;

    public FindClientResult(FindClientResponseItem item,
                            boolean anyClientFound, boolean validClientFound) {
        this.item = item;
        this.status = validClientFound ? FindClientStatus.FOUND :
                (anyClientFound ? FindClientStatus.FOUND_ONLY_INVALID : FindClientStatus.NOT_FOUND);
    }

    /**
     * Результат поиска клиента, когда клиент не найден
     */
    public static FindClientResult clientNotFoundResult() {
        return new FindClientResult(null, false, false);
    }

    /**
     * Результат поиска клиента, когда клиент найден
     *
     * @param item                 найденный клиент
     * @param itemValidationStatus результат валидации клиента. true, если валидный, false иначе
     */
    public static FindClientResult clientFoundResult(FindClientResponseItem item, boolean itemValidationStatus) {
        return new FindClientResult(item, true, itemValidationStatus);
    }

    public FindClientResponseItem getItem() {
        return item;
    }

    public boolean isValidClientFound() {
        return status == FindClientStatus.FOUND;
    }

    public boolean isClientFoundButInvalid() {
        return status == FindClientStatus.FOUND_ONLY_INVALID;
    }

    private enum FindClientStatus {
        FOUND,
        //найден нужный клиент
        NOT_FOUND,
        //не найден никакой клиент
        FOUND_ONLY_INVALID; //найден клиент, но он невалидный(валюта/страна не соответствуют искомым)
    }
}
