package ru.yandex.direct.balance.client.model.response;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown = true)
public class FirmCountryCurrencyItem extends BalanceRpcResponse {
    @JsonProperty("region_id")
    private Integer regionId;

    @JsonProperty("region_name_en")
    private String regionNameEn;

    @JsonProperty("region_name")
    private String regionName;

    @JsonProperty("currency")
    private String currency;

    @JsonProperty("resident")
    private Boolean resident;

    @JsonProperty("firm_id")
    private String firmId;

    @JsonProperty("convert_type_modify")
    private Boolean convertTypeModify;

    public Integer getRegionId() {
        return regionId;
    }

    public void setRegionId(Integer regionId) {
        this.regionId = regionId;
    }

    public FirmCountryCurrencyItem withRegionId(Integer regionId) {
        this.regionId = regionId;
        return this;
    }

    public String getRegionNameEn() {
        return regionNameEn;
    }

    public void setRegionNameEn(String regionNameEn) {
        this.regionNameEn = regionNameEn;
    }

    public FirmCountryCurrencyItem withRegionNameEn(String regionNameEn) {
        this.regionNameEn = regionNameEn;
        return this;
    }

    public String getRegionName() {
        return regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public FirmCountryCurrencyItem withRegionName(String regionName) {
        this.regionName = regionName;
        return this;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public FirmCountryCurrencyItem withCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public Boolean getResident() {
        return resident;
    }

    public void setResident(Boolean resident) {
        this.resident = resident;
    }

    public FirmCountryCurrencyItem withResident(Boolean resident) {
        this.resident = resident;
        return this;
    }

    public String getFirmId() {
        return firmId;
    }

    public void setFirmId(String firmId) {
        this.firmId = firmId;
    }

    public FirmCountryCurrencyItem withFirmId(String firmId) {
        this.firmId = firmId;
        return this;
    }

    public Boolean getConvertTypeModify() {
        return convertTypeModify;
    }

    public void setConvertTypeModify(Boolean convertTypeModify) {
        this.convertTypeModify = convertTypeModify;
    }

    public FirmCountryCurrencyItem withConvertTypeModify(Boolean convertTypeModify) {
        this.convertTypeModify = convertTypeModify;
        return this;
    }
}
