package ru.yandex.direct.balance.client.model.response;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Информация за настройки автоовердрафта
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class GetOverdraftParamsResponse extends BalanceRpcResponse {
    @JsonProperty("ClientID")
    private Long clientId;
    @JsonProperty("ClientLimit")
    private BigDecimal clientLimit;
    @JsonProperty("PaymentMethodCC")
    private String paymentMethodCode;
    @JsonProperty("PersonID")
    private Integer personId;

    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public BigDecimal getClientLimit() {
        return clientLimit;
    }

    public void setClientLimit(BigDecimal clientLimit) {
        this.clientLimit = clientLimit;
    }

    public String getPaymentMethodCode() {
        return paymentMethodCode;
    }

    public void setPaymentMethodCode(String paymentMethodCode) {
        this.paymentMethodCode = paymentMethodCode;
    }

    public Integer getPersonId() {
        return personId;
    }

    public void setPersonId(Integer personId) {
        this.personId = personId;
    }
}
