package ru.yandex.direct.balance.client.model.response;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Информация о способах оплаты
 * <p>
 * https://wiki.yandex-team.ru/Balance/XmlRpc/#vozvrashhaemyeznachenija39
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class GetRequestChoicesResponseFull {
    @JsonProperty("paysys_list")
    private List<PaymentMethod> paymentMethods;
    @JsonProperty("pcp_list")
    private List<PersonPaymentMethodDetailsFull> personPaymentMethodDetails;

    public List<PaymentMethod> getPaymentMethods() {
        return paymentMethods;
    }

    public void setPaymentMethods(List<PaymentMethod> paymentMethods) {
        this.paymentMethods = paymentMethods;
    }

    public List<PersonPaymentMethodDetailsFull> getPersonPaymentMethodDetailsFull() {
        return personPaymentMethodDetails;
    }

    public void setPersonPaymentMethodDetailsFull(
            List<PersonPaymentMethodDetailsFull> personPaymentMethodDetailsFull) {
        this.personPaymentMethodDetails = personPaymentMethodDetails;
    }
}
