package ru.yandex.direct.balance.client.model.response;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.Objects;
import com.univocity.parsers.annotations.Parsed;

/**
 * Класс, описывающий ответ ручки GetLinkedClients.
 * <p>
 * При парсинге ответа отбрасываются поля GROUP_ID, LINK_TYPE так как они нам не нужны
 * <p>
 * ВАЖНО: на использование в equals+hashCode строго двух полей ClientId + brandClientID полагается код уникализации
 * в методе convertResponseDataToModel джобы ClientBrandsImportJob (см. тест testConvertion в
 * ClientBrandsImportJobTest).
 * <p>
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.getlinkedclients
 */
@ParametersAreNonnullByDefault
public class LinkedClientsItem extends BalanceRpcResponse {

    @Parsed(field = "CLIENT_ID")
    private Long clientId;

    @Parsed(field = "BRAND_CLIENT_ID")
    private Long brandClientId;

    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public LinkedClientsItem withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Long getBrandClientId() {
        return brandClientId;
    }

    public void setBrandClientId(Long brandClientId) {
        this.brandClientId = brandClientId;
    }

    public LinkedClientsItem withBrandClientId(Long brandClientId) {
        this.brandClientId = brandClientId;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LinkedClientsItem that = (LinkedClientsItem) o;
        return Objects.equal(clientId, that.clientId) &&
                Objects.equal(brandClientId, that.brandClientId);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(clientId, brandClientId);
    }

    public LinkedClientsItem clientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }
}
