package ru.yandex.direct.balance.client.model.response;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Ответ функции Balance.ListPaymentMethodsSimple
 * Сейчас используем не все доступные поля, подробнее см.
 * https://wiki.yandex-team.ru/Balance/XmlRpc/#balance.listpaymentmethodssimple
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class ListPaymentMethodsSimpleResponseItem {

    @JsonProperty("status")
    private String status;

    @JsonProperty("payment_methods")
    private Map<String, Map<String, Object>> paymentMethods;

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public ListPaymentMethodsSimpleResponseItem withStatus(String status) {
        setStatus(status);
        return this;
    }

    public Map<String, Map<String, Object>> getPaymentMethods() {
        return paymentMethods;
    }

    public void setPaymentMethods(Map<String, Map<String, Object>> paymentMethods) {
        this.paymentMethods = paymentMethods;
    }

    public ListPaymentMethodsSimpleResponseItem withPaymentMethods(Map<String, Map<String, Object>> paymentMethods) {
        setPaymentMethods(paymentMethods);
        return this;
    }

}
