package ru.yandex.direct.balance.client.model.response;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * Информация о клиенте в результате метода GetPartnerContracts
 * <p>
 * В текущей реализации только часть полей, потому что на момент написания далеко не все из них нам (Директу) нужны;
 * примерный формат результата со всеми данными, которые есть, можно поискать или посмотреть на вики здесь:
 *
 * @link https://wiki.yandex-team.ru/partner/w/external-services-api-balance-get-partner-contracts/
 */
@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown = true)
public class PartnerContractClientInfo {
    private Long id;

    @JsonProperty("agency_id")
    private Long agencyId;

    @JsonProperty("is_agency")
    private Boolean isAgency;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAgencyId() {
        return agencyId;
    }

    public void setAgencyId(Long agencyId) {
        this.agencyId = agencyId;
    }

    @JsonGetter("is_agency")
    public Boolean isAgency() {
        return isAgency;
    }

    public void setAgency(Boolean agency) {
        isAgency = agency;
    }

    @JsonSetter("is_agency")
    public void setAgency(@Nullable Long agency) {
        setAgency(agency != null && agency == 1);
    }
}
