package ru.yandex.direct.balance.client.model.response;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Элемент ответа метода GetPartnerContracts
 * <p>
 * Примерный формат результата со всеми данными, которые есть, можно поискать или посмотреть на вики здесь:
 *
 * @link https://wiki.yandex-team.ru/partner/w/external-services-api-balance-get-partner-contracts/
 */
@ParametersAreNonnullByDefault
public class PartnerContractInfo {
    @JsonProperty("Client")
    private final PartnerContractClientInfo client;

    @JsonProperty("Collaterals")
    private final List<PartnerContractCollateralInfo> collaterals;

    @JsonProperty("Contract")
    private final PartnerContractContractInfo contract;

    @JsonProperty("Person")
    private final PartnerContractPersonInfo person;

    @JsonCreator
    public PartnerContractInfo(
            @JsonProperty("Client") PartnerContractClientInfo client,
            @JsonProperty("Collaterals") List<PartnerContractCollateralInfo> collaterals,
            @JsonProperty("Contract") PartnerContractContractInfo contract,
            @JsonProperty("Person") PartnerContractPersonInfo person) {
        this.client = client;
        this.collaterals = collaterals;
        this.contract = contract;
        this.person = person;
    }

    public PartnerContractClientInfo getClient() {
        return client;
    }

    public List<PartnerContractCollateralInfo> getCollaterals() {
        return collaterals;
    }

    public PartnerContractContractInfo getContract() {
        return contract;
    }

    public PartnerContractPersonInfo getPerson() {
        return person;
    }

    @Override
    public String toString() {
        return "PartnerContractInfo{" +
                "client=" + client +
                ", collaterals=" + collaterals +
                ", contract=" + contract +
                ", person=" + person +
                '}';
    }
}
