package ru.yandex.direct.balance.client.model.response;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Хранит сслыку на форму траста для оплаты
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.payrequest
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class PayRequestResponse {

    @JsonProperty("payment_url")
    private String paymentUrl;

    @JsonProperty("request_id")
    private Long requestId;

    @JsonProperty("amount")
    private BigDecimal amount;

    public String getPaymentUrl() {
        return paymentUrl;
    }

    public Long getRequestId() {
        return requestId;
    }

    public BigDecimal getAmount() {
        return amount;
    }
}
