package ru.yandex.direct.balance.client.model.response;

import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Способы оплаты
 * <p>
 * https://wiki.yandex-team.ru/Balance/XmlRpc/#vozvrashhaemyeznachenija39
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PaymentMethodDetailsFull extends PaymentMethodDetails {
    @JsonProperty("cc")
    private String code;
    @JsonProperty("disabled_reasons")
    private Set<String> disabledReasons;
    @JsonProperty("id")
    private Long id;
    @JsonProperty("legal_entity")
    private Boolean legalEntity;
    @JsonProperty("name")
    private String name;
    @JsonProperty("region_id")
    private Long regionId;
    @JsonProperty("resident")
    private Boolean resident;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Set<String> getDisabledReasons() {
        return disabledReasons;
    }

    public void setDisabledReasons(Set<String> disabledReasons) {
        this.disabledReasons = disabledReasons;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getLegalEntity() {
        return legalEntity;
    }

    public void setLegalEntity(Boolean legalEntity) {
        this.legalEntity = legalEntity;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getRegionId() {
        return regionId;
    }

    public void setRegionId(Long regionId) {
        this.regionId = regionId;
    }

    public Boolean getResident() {
        return resident;
    }

    public void setResident(Boolean resident) {
        this.resident = resident;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PaymentMethodDetailsFull that = (PaymentMethodDetailsFull) o;
        return Objects.equals(id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}
