package ru.yandex.direct.balance.client.model.response;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Список возможных наборов: плательщик, договор, способы оплаты
 * <p>
 * https://wiki.yandex-team.ru/Balance/XmlRpc/#vozvrashhaemyeznachenija57
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PersonPaymentMethodDetails extends BalanceRpcResponse {
    @JsonProperty("paysyses")
    private List<PaymentMethodDetails> paymentMethodDetails;
    @JsonProperty("person")
    private Person person;
    @JsonProperty("contract")
    private Contract contract;

    public List<PaymentMethodDetails> getPaymentMethodDetails() {
        return paymentMethodDetails;
    }

    public void setPaymentMethodDetails(List<PaymentMethodDetails> paymentMethodDetails) {
        this.paymentMethodDetails = paymentMethodDetails;
    }

    public Person getPerson() {
        return person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public Contract getContract() {
        return contract;
    }

    public void setContract(Contract contract) {
        this.contract = contract;
    }
}
