package ru.yandex.direct.balance.client.model.response;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Список возможных наборов: плательщик и способы оплаты
 * <p>
 * https://wiki.yandex-team.ru/Balance/XmlRpc/#vozvrashhaemyeznachenija39
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PersonPaymentMethodDetailsFull extends BalanceRpcResponse {
    @JsonProperty("paysyses")
    private List<PaymentMethodDetailsFull> paymentMethodDetailsFull;
    @JsonProperty("person")
    private Person person;

    public List<PaymentMethodDetailsFull> getPaymentMethodDetailsFull() {
        return paymentMethodDetailsFull;
    }

    public void setPaymentMethodDetailsFull(List<PaymentMethodDetailsFull> paymentMethodDetailsFull) {
        this.paymentMethodDetailsFull = paymentMethodDetailsFull;
    }

    public Person getPerson() {
        return person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }
}
