package ru.yandex.direct.bangenproxy.client

import ru.yandex.direct.bangenproxy.client.model.*
import ru.yandex.direct.http.smart.annotations.Json
import ru.yandex.direct.http.smart.core.Call
import ru.yandex.direct.http.smart.http.Body
import ru.yandex.direct.http.smart.http.HeaderMap
import ru.yandex.direct.http.smart.http.POST
import javax.annotation.ParametersAreNonnullByDefault

@ParametersAreNonnullByDefault
interface BanGenProxyApi {
    @POST("/v1/uc")
    @Json
    fun getUrlInfoForUc(@Body @Json getTextSuggestsRequest: GetTextSuggestionsRequest): Call<TextInfoUc>

    @POST("/v1/combinatorics")
    @Json
    fun getUrlInfoForCombinatorics(
        @Body @Json getTextSuggestsRequest: GetTextSuggestionsRequest): Call<TextInfoCombinatorics>

    @POST("/v2/combinatorics")
    @Json
    fun getUrlInfoForCombinatoricsNew(
        @HeaderMap headers: Map<String, String>,
        @Body @Json getTextSuggestsRequest: GetTextSuggestionsRequest
        ): Call<TextInfoCombinatorics>

    @POST("/v1/custom")
    @Json
    fun getUrlInfoForCustom(
        @Body @Json getTextSuggestsByContentRequest: GetTextSuggestsByContentRequest): Call<TextInfoCustom>
}
