package ru.yandex.direct.bangenproxy.client

import ru.yandex.direct.asynchttp.ParallelFetcherFactory
import ru.yandex.direct.bangenproxy.client.model.*
import ru.yandex.direct.http.smart.core.Call
import ru.yandex.direct.http.smart.core.Smart
import ru.yandex.direct.http.smart.error.ErrorUtils
import ru.yandex.direct.tvm.TvmIntegration
import ru.yandex.direct.tvm.TvmService
import ru.yandex.inside.passport.tvm2.TvmHeaders

class BanGenProxyClient(
    baseUrl: String,
    fetcherFactory: ParallelFetcherFactory,
    var tvmIntegration: TvmIntegration,
) {

    private val banGenProxyApi: BanGenProxyApi = Smart.builder()
        .withParallelFetcherFactory(fetcherFactory)
        .withProfileName("bangen_proxy_client")
        .withBaseUrl(baseUrl)
        .build()
        .create(BanGenProxyApi::class.java)

    fun getUrlInfoForUc(
        url: String,
        existingTitles: List<String>,
        existingBodies: List<String>
    ): TextInfoUc {
        val call = banGenProxyApi.getUrlInfoForUc(createUrlRequest(url, existingTitles, existingBodies))
        return getResponse(call)
    }

    fun getUrlInfoForCombinatorics(
        url: String,
        userText: String? = null,
        existingTitles: List<String>,
        existingBodies: List<String>,
    ): TextInfoCombinatorics {
        val tvmHeader =
            mapOf<String, String>(TvmHeaders.SERVICE_TICKET to tvmIntegration.getTicket(TvmService.BANGEN_PROXY_PROD))
        val call = banGenProxyApi
            .getUrlInfoForCombinatoricsNew(tvmHeader, createUrlRequest(url, existingTitles, existingBodies, userText))
        return getResponse(call)
    }

    fun getUrlInfoForCustom(
        title: String,
        snippet: String
    ): TextInfoCustom {
        val call = banGenProxyApi.getUrlInfoForCustom(createCustomRequest(title, snippet))
        return getResponse(call)
    }

    private fun <T> getResponse(call: Call<T>): T {
        val serviceResponse = call.execute()
        ErrorUtils.checkResultForErrors(serviceResponse, ::BanGenProxyClientException)
        return serviceResponse.success
    }

    private fun createUrlRequest(
        url: String,
        existingTitles: List<String>,
        existingBodies: List<String>,
        userText: String? = null
    ): GetTextSuggestionsRequest = GetTextSuggestionsRequest(
        url,
        userText,
        existingTitles,
        existingBodies,
    )

    private fun createCustomRequest(
        title: String,
        snippet: String
    ): GetTextSuggestsByContentRequest = GetTextSuggestsByContentRequest(
        title,
        snippet
    )
}
