package ru.yandex.direct.bangenproxy.client.zenmeta;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.asynchttp.Result;
import ru.yandex.direct.bangenproxy.client.zenmeta.model.ZenMetaInfo;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.error.ErrorUtils;

@ParametersAreNonnullByDefault
public final class ZenMetaInfoClient {
    private final ZenMetaInfoApi api;

    public ZenMetaInfoClient(ZenMetaInfoApi api) {
        this.api = api;
    }

    public ZenMetaInfo getZenMetaInfoByUrl(String url) {
        var contentId = getContentIdByUrl(url);
        if (contentId.isEmpty()) {
            throw new ZenMetaInfoClientException("Error while parsing zen url");
        }
        Call<ZenMetaInfo> call = api.getZenMetaInfoByUrl(contentId.get());
        Result<ZenMetaInfo> serviceResponse = call.execute();
        ErrorUtils.checkResultForErrors(serviceResponse, ZenMetaInfoClientException::new);
        return serviceResponse.getSuccess();

    }

    public static Optional<String> getContentIdByUrl(String sUrl) {
        try {
            URL url = new URL(sUrl);
            String path = url.getPath();
            if (path.startsWith("/media")) {
                //if path starts with "/media/" it is a publication. Skip /media/ by splitting url
                return Optional.of(path.split("/", 3)[2]);
            }
            //else it is a zen channel. Skip first "/"
            var splittedPath = path.split("/", 2);
            if (splittedPath.length < 2 || splittedPath[1].isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(splittedPath[1]);
        } catch (MalformedURLException e) {
            return Optional.empty();
        }
    }
}
