package ru.yandex.direct.bangenproxy.client.zenmeta.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class ZenMetaInfo {
    @JsonProperty("publisherId")
    private String publisherId;
    @JsonProperty("publisherItemId")
    private String publisherItemId;
    @JsonProperty("title")
    @JsonAlias("name")
    private String title;
    @JsonProperty("snippet")
    private String snippet;
    @JsonProperty("content")
    @JsonAlias("description")
    private String content;
    @JsonProperty("imageUrls")
    @JsonAlias("logoUrls")
    private List<String> imageUrls;
    @JsonProperty("publisherVacuumCounterId")
    private Long publisherVacuumCounterId;

    public String getPublisherId() {
        return publisherId;
    }

    public ZenMetaInfo withPublisherId(String publisherId) {
        this.publisherId = publisherId;
        return this;
    }

    public String getPublisherItemId() {
        return publisherItemId;
    }

    public ZenMetaInfo withPublisherItemId(String publisherItemId) {
        this.publisherItemId = publisherItemId;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public ZenMetaInfo withTitle(String title) {
        this.title = title;
        return this;
    }

    public String getSnippet() {
        return snippet;
    }

    public ZenMetaInfo withSnippet(String snippet) {
        this.snippet = snippet;
        return this;
    }

    public String getContent() {
        return content;
    }

    public ZenMetaInfo withContent(String content) {
        this.content = content;
        return this;
    }

    public List<String> getImageUrls() {
        return imageUrls;
    }

    public ZenMetaInfo withImageUrls(List<String> imageUrls) {
        this.imageUrls = imageUrls;
        return this;
    }

    public Long getPublisherVacuumCounterId() {
        return publisherVacuumCounterId;
    }

    public ZenMetaInfo withPublisherVacuumCounterId(Long publisherVacuumCounterId) {
        this.publisherVacuumCounterId = publisherVacuumCounterId;
        return this;
    }
}
