package ru.yandex.direct.bannercategoriesmultik.client;

import java.nio.charset.Charset;

import javax.annotation.ParametersAreNonnullByDefault;

import NBg.NProto.CaesarModelsRequest.TCaesarBannerMultiksRequest;
import NBg.NProto.CaesarModelsRequest.TCaesarBannerMultiksRequest.TBanner;
import NBg.NProto.CaesarModelsRequest.TCaesarBannerMultiksResponse;
import NBg.NProto.CaesarModelsRequest.TCaesarBannerMultiksResponse.TBannerResult;
import NCSR.Banner.TBannerProfileProto;
import NCSR.Banner.TBannerProfileProto.TResources;
import com.google.protobuf.ByteString;

import ru.yandex.direct.asynchttp.ParallelFetcherFactory;
import ru.yandex.direct.asynchttp.Result;
import ru.yandex.direct.bannercategoriesmultik.client.model.BannerCategories;
import ru.yandex.direct.bannercategoriesmultik.client.model.BannerInfo;
import ru.yandex.direct.bannercategoriesmultik.client.model.CategoriesRequest;
import ru.yandex.direct.bannercategoriesmultik.client.model.CategoriesResponse;
import ru.yandex.direct.http.smart.core.Smart;

import static java.nio.charset.StandardCharsets.UTF_8;
import static ru.yandex.direct.http.smart.error.ErrorUtils.checkResultForErrors;
import static ru.yandex.direct.utils.FunctionalUtils.listToMap;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
public class BannerCategoriesMultikClient {

    private static final Charset CHARSET = UTF_8;

    private final BannerCategoriesMultikApi bannerCategoriesMultikApi;

    public BannerCategoriesMultikClient(String baseUrl, ParallelFetcherFactory fetcherFactory) {
        bannerCategoriesMultikApi = Smart.builder()
                .withParallelFetcherFactory(fetcherFactory)
                .withProfileName("multik_client")
                .withBaseUrl(baseUrl)
                .build()
                .create(BannerCategoriesMultikApi.class);
    }

    public CategoriesResponse getCategories(CategoriesRequest req) {
        TCaesarBannerMultiksRequest multikRequest = multikRequest(req);
        Result<TCaesarBannerMultiksResponse> result =
                bannerCategoriesMultikApi.getCategoriesFromMultik(multikRequest).execute();
        checkResultForErrors(result, BannerCategoriesMultikClientException::new, req);
        TCaesarBannerMultiksResponse multikResponse = result.getSuccess();
        return new CategoriesResponse(mapList(multikResponse.getResultsList(),
                BannerCategoriesMultikClient::getCategories));
    }

    private static TCaesarBannerMultiksRequest multikRequest(CategoriesRequest req) {
        return TCaesarBannerMultiksRequest.newBuilder()
                .setMaxCategoriesNumber(req.getMaxCategoriesNumber())
                .addAllBanners(mapList(req.getBannersInfo(), BannerCategoriesMultikClient::toBanner))
                .build();
    }

    private static TBanner toBanner(BannerInfo info) {
        return TBanner.newBuilder()
                .setBannerProfileProto(TBannerProfileProto.newBuilder()
                        .setResources(toResources(info))
                        .build())
                .build();
    }

    private static TResources toResources(BannerInfo info) {
        return TResources.newBuilder()
                .setTitle(toByteString(info.getTitle()))
                .setBody(toByteString(info.getBody()))
                .setHref(toByteString(info.getHref()))
                .build();
    }

    private static ByteString toByteString(String s) {
        return ByteString.copyFrom(s, CHARSET);
    }

    private static BannerCategories getCategories(TBannerResult res) {
        return new BannerCategories(listToMap(res.getMultiksList(),
                TResources.TMultikCategories::getModelID,
                TResources.TMultikCategories::getCategoriesList));
    }

}
