package ru.yandex.direct.bannercategoriesmultik.client.model;

import java.util.List;

public class CategoriesRequest {

    private final List<BannerInfo> banners;
    private final int maxCategoriesNumber;

    public CategoriesRequest(List<BannerInfo> banners, int maxCategoriesNumber) {
        if (maxCategoriesNumber <= 0) {
            throw new IllegalArgumentException("maxCategoriesNumber should be positive");
        }
        this.banners = banners;
        this.maxCategoriesNumber = maxCategoriesNumber;
    }

    public List<BannerInfo> getBannersInfo() {
        return banners;
    }

    public int getMaxCategoriesNumber() {
        return maxCategoriesNumber;
    }
}
