package ru.yandex.direct.bannerstorage.client;

import ru.yandex.direct.bannerstorage.client.model.Creative;
import ru.yandex.direct.bannerstorage.client.model.CreativeGroup;
import ru.yandex.direct.bannerstorage.client.model.CreativesList;
import ru.yandex.direct.bannerstorage.client.model.File;
import ru.yandex.direct.bannerstorage.client.model.ItemsRequest;
import ru.yandex.direct.bannerstorage.client.model.PreviewRequest;
import ru.yandex.direct.bannerstorage.client.model.PreviewsList;
import ru.yandex.direct.bannerstorage.client.model.Template;
import ru.yandex.direct.bannerstorage.client.model.TemplatesList;
import ru.yandex.direct.http.smart.annotations.Json;
import ru.yandex.direct.http.smart.annotations.ResponseHandler;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.http.Body;
import ru.yandex.direct.http.smart.http.GET;
import ru.yandex.direct.http.smart.http.Header;
import ru.yandex.direct.http.smart.http.PATCH;
import ru.yandex.direct.http.smart.http.POST;
import ru.yandex.direct.http.smart.http.PUT;
import ru.yandex.direct.http.smart.http.Path;
import ru.yandex.direct.http.smart.http.Query;

public interface Api {
    @POST("/creatives/")
    @Json
    @ResponseHandler(expectedCodes = 201)
    Call<Creative> postCreative(@Body @Json Creative creative,
                                @Query("include") String commaSeparatedIncludes,
                                @Header("Accept-Language") String acceptLanguage);

    @PUT("/creatives/{id}")
    @Json
    Call<Creative> putCreative(@Path("id") Integer creativeId,
                               @Body @Json Creative creative,
                               @Query("include") String commaSeparatedIncludes,
                               @Header("Accept-Language") String acceptLanguage);

    @PUT("/creatives/{id}/tnsarticles")
    @Json
    Call<ItemsRequest> putTnsArticles(@Path("id") Integer creativeId, @Body @Json ItemsRequest itemsRequest);

    @PUT("/creatives/{id}/tnsbrands")
    @Json
    Call<ItemsRequest> putTnsBrands(@Path("id") Integer creativeId, @Body @Json ItemsRequest itemsRequest);

    @POST("/creatives/{id}/requestModeration")
    @Json
    @ResponseHandler(expectedCodes = 201)
    Call<Creative> requestModeration(@Path("id") Integer creativeId);

    @POST("/creatives/{id}/requestEdit")
    @Json
    @ResponseHandler(expectedCodes = 201)
    Call<Creative> requestEdit(@Path("id") Integer creativeId);

    @GET("/creatives")
    @Json
    Call<CreativesList> getCreatives(@Query("ids") String commaSeparatedIds,
                                     @Query("include") String commaSeparatedIncludes);

    @POST("/creatives/{id}/moderatedExternally")
    @Json
    @ResponseHandler(expectedCodes = 201)
    Call<Creative> setModeratedExternally(@Path("id") Integer creativeId);

    @GET("/files/{id}/extended")
    @Json
    Call<File> getFile(@Path("id") Integer fileId);

    @GET("/templates")
    @Json
    Call<TemplatesList> getTemplates(@Query("include") String commaSeparatedIncludes);

    @GET("/templates/{id}")
    @Json
    Call<Template> getTemplate(@Path("id") int templateId,
                               @Query("include") String commaSeparatedIncludes);

    @POST("/creatives/{id}/versions/{versionId}/approve")
    @Json
    @ResponseHandler(expectedCodes = 201)
    Call<Creative> approveExternallyModeratedCreative(@Path("id") Integer creativeId,
                                                      @Path("versionId") Integer creativeVersionId);

    @POST("/creatives/{id}/versions/{versionId}/reject")
    @Json
    @ResponseHandler(expectedCodes = 201)
    Call<Creative> rejectExternallyModeratedCreative(@Path("id") Integer creativeId,
                                                     @Path("versionId") Integer creativeVersionId);

    @GET("/creativeGroups/{id}")
    @Json
    Call<CreativeGroup> getCreativeGroup(@Path("id") Integer creativeGroupId,
                                         @Query("include") String commaSeparatedIncludes);

    @POST("/creatives/preview_v2")
    @Json
    @ResponseHandler(expectedCodes = 201)
    Call<PreviewsList> getPreviews(@Body @Json PreviewRequest previewRequest);

    @POST("/creativeGroups")
    @Json
    @ResponseHandler(expectedCodes = 201)
    Call<CreativeGroup> createCreativeGroup(@Body @Json CreativeGroup creativeGroup,
                                            @Query("add_defaults") Boolean addDefaults,
                                            @Query("include") String commaSeparatedIncludes);

    @PATCH("/creativeGroups/{id}")
    @Json
    Call<CreativeGroup> editCreativeGroup(@Path("id") Integer creativeGroupId,
                                          @Body @Json CreativeGroup creativeGroup,
                                          @Query("merge_existing") Boolean mergeExisting,
                                          @Query("include") String commaSeparatedIncludes);
}
