package ru.yandex.direct.bannerstorage.client;

import java.util.Collection;
import java.util.List;
import java.util.Locale;

import ru.yandex.direct.bannerstorage.client.model.Creative;
import ru.yandex.direct.bannerstorage.client.model.CreativeGroup;
import ru.yandex.direct.bannerstorage.client.model.CreativeInclude;
import ru.yandex.direct.bannerstorage.client.model.File;
import ru.yandex.direct.bannerstorage.client.model.ItemsRequest;
import ru.yandex.direct.bannerstorage.client.model.Parameter;
import ru.yandex.direct.bannerstorage.client.model.Preview;
import ru.yandex.direct.bannerstorage.client.model.Template;
import ru.yandex.direct.bannerstorage.client.model.TemplateInclude;
import ru.yandex.direct.bannerstorage.client.model.UploadedFile;

public interface BannerStorageClient {
    /**
     * Максимальный размер пачки креативов, которую можно получить за один запрос getCreatives()
     */
    int MAX_CREATIVES_IN_BATCH = 100;

    /**
     * Максимальный размер файла, который можно загружать в bannerstorage
     * Пока 100 МБ
     */
    long MAX_FILE_SIZE = 100 * 1024 * 1024;

    // Статус креатива "Редактируется"
    int STATUS_DRAFT = 1;

    // Статус "На модерации"
    int STATUS_MODERATING = 2;

    // Статус "Отклонён"
    int STATUS_REJECTED = 3;

    // Статус "Принят"
    int STATUS_ACCEPTED = 4;

    // layoutId, соответствующий смарт-ТГО
    int SMART_TGO_LAYOUT_ID = 44;

    // Это значение возвращается из АПИ в качестве значения 'true' для параметра с типом 'flag'
    String FLAG_TRUE_VALUE = "1";

    Creative createCreative(Creative creative, Locale locale, CreativeInclude... includes);

    Creative updateCreative(Creative creative, Locale locale, CreativeInclude... includes);

    ItemsRequest addTnsArticles(Integer creativeId, ItemsRequest request);

    ItemsRequest addTnsBrands(Integer creativeId, ItemsRequest request);

    Creative requestModeration(Integer creativeId);

    Creative requestEdit(Integer creativeId);

    /**
     * Возвращает креативы, но не более MAX_CREATIVES_IN_BATCH одновременно.
     */
    List<Creative> getCreatives(Collection<Integer> creativeIds, CreativeInclude... includes);

    /**
     * Устанавливает признак того, что креатив будет модерироваться модерацией Директа,
     * а не собственной модерацией bannerstorage
     */
    Creative setModeratedExternally(Integer creativeId);

    /**
     * Получает информацию о загруженном в bannerstorage файле
     */
    File getFile(Integer fileId);

    /**
     * Возвращает информацию обо всех доступных шаблонах
     */
    List<Template> getTemplates(TemplateInclude... includes);

    /**
     * Возвращает информацию об одном шаблоне
     */
    Template getTemplate(int templateId, TemplateInclude... includes);

    /**
     * Переводит указанную версию креатива, модерируемого модерацией Директа, в статус "Принят"
     */
    void approveExternallyModeratedCreative(Integer creativeId, Integer creativeVersionId);

    /**
     * Переводит указанную версию креатива, модерируемого модерацией Директа, в статус "Отклонён"
     */
    void rejectExternallyModeratedCreative(Integer creativeId, Integer creativeVersionId);

    UploadedFile uploadFile(byte[] data, String fileName);

    UploadedFile uploadFile(java.io.File file, String fileName);

    /**
     * Получение группы смартовых креативов по id
     */
    CreativeGroup getSmartCreativeGroup(int id, CreativeInclude... includes);

    /**
     * Получение превью для существующих смартовых креативов
     *
     * @param creativeIds        Креативы, которые редактируются
     * @param modifiedParameters Список параметров, изменённых пользователем
     * @param dcParams           Кусок фида для превью
     */
    List<Preview> getSmartGroupPreviews(List<Integer> creativeIds, List<Parameter> modifiedParameters, String dcParams);

    /**
     * Получение превью для новой (ещё не созданной) смартовой группы креативов
     *
     * @param templateId         Номер шаблона
     * @param modifiedParameters Список параметров, изменённых пользователем
     * @param dcParams           Кусок фида для превью
     */
    List<Preview> getSmartGroupPreviews(int templateId, List<Parameter> modifiedParameters, String dcParams);

    /**
     * Создаёт новую группу смартовых креативов
     *
     * @param creativeGroup У группы должно быть указано name, у креативов должны быть указаны поля:
     *                      templateId, layoutCodeId, parameters
     */
    CreativeGroup createSmartCreativeGroup(CreativeGroup creativeGroup);

    /**
     * Сохраняет уже существующую группу смартовых креативов
     *
     * @param id            id группы креативов
     * @param creativeGroup У группы должно быть указано name, у креативов должны быть указаны поля:
     *                      id, version, parameters
     */
    CreativeGroup editSmartCreativeGroup(int id, CreativeGroup creativeGroup);
}
