package ru.yandex.direct.bannerstorage.client;

import java.io.File;
import java.io.IOException;
import java.time.Duration;

import com.google.common.base.Preconditions;
import org.apache.commons.io.FileUtils;

import static com.google.common.base.Strings.isNullOrEmpty;

public class BannerStorageClientConfiguration {
    private static final String ENCODING = "UTF-8";
    private static final Duration REQUEST_TIMEOUT = Duration.ofSeconds(15);
    // Отдельный таймаут для аплоада файлов, т.к. он может выполняться дольше
    private static final Duration FILE_UPLOAD_TIMEOUT = Duration.ofSeconds(60);

    private String url;

    private String token;

    private Duration timeout;

    private Duration fileUploadTimeout;

    public BannerStorageClientConfiguration(String url, String token, String tokenFilePath) {
        Preconditions.checkArgument(!isNullOrEmpty(url));
        Preconditions.checkArgument(token != null || tokenFilePath != null, "Invalid token");

        this.url = url;
        if (token == null || token.isEmpty()) {
            token = getAuthTokenFromFile(tokenFilePath);
        }
        this.token = token;
        this.timeout = REQUEST_TIMEOUT;
        this.fileUploadTimeout = FILE_UPLOAD_TIMEOUT;
    }

    public String getUrl() {
        return url;
    }

    public String getToken() {
        return token;
    }

    public Duration getTimeout() {
        return timeout;
    }

    public Duration getFileUploadTimeout() {
        return fileUploadTimeout;
    }

    String getAuthTokenFromFile(String tokenFilePath) {
        try {
            return FileUtils.readFileToString(new File(tokenFilePath), ENCODING).trim();
        } catch (IOException e) {
            throw new BannerStorageClientException("failed to read auth_token from token_file: " + tokenFilePath, e);
        }
    }

}
