package ru.yandex.direct.bannerstorage.client;

import java.util.Map;
import java.util.Set;

import javax.annotation.Nullable;

import one.util.streamex.IntStreamEx;
import org.apache.commons.lang3.tuple.Pair;

public class Utils {
    private static final Set<Integer> OBSOLETE_LAYOUT_IDS = IntStreamEx.rangeClosed(1, 7)
            .append(IntStreamEx.rangeClosed(20, 43)).boxed().toImmutableSet();

    // В каких размерах отображать адаптивные размеры (таблицу составлял Дима Уляшев)
    private static final Map<Integer, Pair<Integer, Integer>> ADAPTIVE_SIZES =
            Map.ofEntries(
                    Map.entry(44, Pair.of(240, 400)),  // Смарт-ТГО
                    Map.entry(45, Pair.of(336, 370)),  // Смарт-плитка 1х1
                    Map.entry(46, Pair.of(300, 300)),  // Смарт-плитка 1x2
                    Map.entry(47, Pair.of(160, 600)),  // Смарт-плитка 1x3
                    Map.entry(48, Pair.of(600, 340)),  // Смарт-плитка 2x1
                    Map.entry(49, Pair.of(600, 340)),  // Смарт-плитка 2x2
                    Map.entry(50, Pair.of(240, 600)),  // Смарт-плитка 2x3
                    Map.entry(51, Pair.of(636, 218)),  // Смарт-плитка 3x1
                    Map.entry(52, Pair.of(970, 250)),  // Смарт-плитка 3x2
                    Map.entry(53, Pair.of(970, 250)),  // Смарт-плитка 3x3
                    Map.entry(54, Pair.of(240, 400)),  // Мозаика Вертикальный
                    Map.entry(55, Pair.of(300, 600)),  // Мозаика Вертикальный Большой
                    Map.entry(56, Pair.of(160, 600)),  // Мозаика Вертикальный Удлиненный
                    Map.entry(57, Pair.of(240, 240)),  // Мозаика Квадратный
                    Map.entry(58, Pair.of(320, 280)),  // Мозаика Квадратный Большой
                    Map.entry(59, Pair.of(400, 220)),  // Мозаика Горизонтальный
                    Map.entry(60, Pair.of(600, 180)),  // Мозаика Горизонтальный Большой
                    Map.entry(61, Pair.of(900, 110))   // Мозаика Горизонтальный Удлиненный

            );

    public static int getSmartCreativeDisplayWidth(int width, int layoutId) {
        if (width != 0) {
            return width;
        }
        if (ADAPTIVE_SIZES.containsKey(layoutId)) {
            return ADAPTIVE_SIZES.get(layoutId).getLeft();
        }
        // Если нет информации, возвращаем 0, модерация всё равно отобразит как-нибудь этот креатив
        return 0;
    }

    public static int getSmartCreativeDisplayHeight(int height, int layoutId) {
        if (height != 0) {
            return height;
        }
        if (ADAPTIVE_SIZES.containsKey(layoutId)) {
            return ADAPTIVE_SIZES.get(layoutId).getRight();
        }
        // Если нет информации, возвращаем 0, модерация всё равно отобразит как-нибудь этот креатив
        return 0;
    }

    /**
     * Определяет, с плиткой ли имеем дело по номеру макета
     */
    public static boolean isSmartTile(int layoutId) {
        return layoutId >= 45 && layoutId <= 54;
    }

    /**
     * По номеру макета определяет, считаем ли мы креатив устаревшим (DIRECT-148277)
     */
    public static boolean isPerformanceLayoutObsolete(@Nullable Integer layoutId) {
        return layoutId == null || OBSOLETE_LAYOUT_IDS.contains(layoutId);
    }
    /**
     * По номеру макета определяет, считаем ли мы креатив устаревшим (DIRECT-148277)
     */
    public static boolean isPerformanceLayoutObsolete(@Nullable Long layoutId) {
        return layoutId == null || OBSOLETE_LAYOUT_IDS.contains(layoutId.intValue());
    }
}
