package ru.yandex.direct.bannerstorage.client.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import static java.util.stream.Collectors.toList;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class Creative {
    @JsonProperty("path")
    private String path;
    // TODO : change to Long
    @JsonProperty("id")
    private Integer id;
    @JsonProperty("templateId")
    private Integer templateId;
    @JsonProperty("width")
    private Integer width;
    @JsonProperty("height")
    private Integer height;
    @JsonProperty("name")
    private String name;
    @JsonProperty("tag")
    private String tag;
    @JsonProperty("note")
    private String note;
    @JsonProperty("expireDate")
    private String expireDate;
    @JsonProperty("parameters")
    private List<Parameter> parameters = null;
    @JsonProperty("status")
    private Integer status;
    @JsonProperty("version")
    private Integer version;
    @JsonProperty("subVersion")
    private Integer subVersion;
    @JsonProperty("thumbnailUrl")
    private String thumbnailUrl;
    @JsonProperty("thumbnailWidth")
    private Integer thumbnailWidth;
    @JsonProperty("thumbnailHeight")
    private Integer thumbnailHeight;
    @JsonProperty("predeployed")
    private Boolean predeployed;
    @JsonProperty("preview")
    private CreativePreview preview;
    @JsonProperty("screenshotUrl")
    private String screenshotUrl;
    @JsonProperty("layoutCode")
    private CreativeLayoutCode layoutCode;
    @JsonProperty("layoutCodeId")
    private Integer layoutCodeId;
    @JsonProperty("groupId")
    private Integer groupId;
    @JsonProperty("businessType")
    private BusinessType businessType;
    @JsonProperty("tnsArticles")
    private List<TnsArticle> tnsArticles;
    @JsonProperty("tnsBrands")
    private List<TnsBrand> tnsBrands;

    public Creative() {
    }

    // copy ctor
    public Creative(Creative other) {
        this.path = other.path;
        this.id = other.id;
        this.templateId = other.templateId;
        this.width = other.width;
        this.height = other.height;
        this.name = other.name;
        this.tag = other.tag;
        this.note = other.note;
        this.expireDate = other.expireDate;
        this.parameters = other.parameters != null ? mapList(other.parameters, Parameter::new) : null;
        this.status = other.status;
        this.version = other.version;
        this.subVersion = other.subVersion;
        this.thumbnailUrl = other.thumbnailUrl;
        this.thumbnailWidth = other.thumbnailWidth;
        this.thumbnailHeight = other.thumbnailHeight;
        this.predeployed = other.predeployed;
        this.preview = other.preview != null ? new CreativePreview(other.preview) : null;
        this.screenshotUrl = other.screenshotUrl;
        this.layoutCodeId = other.layoutCodeId;
        this.layoutCode = other.layoutCode != null ? new CreativeLayoutCode(other.layoutCode) : null;
        this.groupId = other.groupId;
        this.businessType = other.businessType != null ? new BusinessType(other.businessType) : null;
        this.tnsArticles = other.tnsArticles != null
                ? other.tnsArticles.stream().map(TnsArticle::new).collect(toList()) : null;
        this.tnsBrands = other.tnsBrands != null
                ? other.tnsBrands.stream().map(TnsBrand::new).collect(toList()) : null;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Creative withPath(String path) {
        this.path = path;
        return this;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Creative withId(Integer id) {
        this.id = id;
        return this;
    }

    public Integer getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Integer templateId) {
        this.templateId = templateId;
    }

    public Creative withTemplateId(Integer templateId) {
        this.templateId = templateId;
        return this;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Creative withWidth(Integer width) {
        this.width = width;
        return this;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Creative withHeight(Integer height) {
        this.height = height;
        return this;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Creative withName(String name) {
        this.name = name;
        return this;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Creative withTag(String tag) {
        this.tag = tag;
        return this;
    }

    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Creative withNote(String note) {
        this.note = note;
        return this;
    }

    public String getExpireDate() {
        return expireDate;
    }

    public void setExpireDate(String expireDate) {
        this.expireDate = expireDate;
    }

    public Creative withExpireDate(String expireDate) {
        this.expireDate = expireDate;
        return this;
    }

    public List<Parameter> getParameters() {
        return parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public Creative withParameters(List<Parameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Creative withStatus(Integer status) {
        this.status = status;
        return this;
    }

    public Integer getVersion() {
        return version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Creative withVersion(Integer version) {
        this.version = version;
        return this;
    }

    public Integer getSubVersion() {
        return subVersion;
    }

    public void setSubVersion(Integer subVersion) {
        this.subVersion = subVersion;
    }

    public Creative withSubVersion(Integer subVersion) {
        this.subVersion = subVersion;
        return this;
    }

    public String getThumbnailUrl() {
        return thumbnailUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    public Creative withThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
        return this;
    }

    public Integer getThumbnailWidth() {
        return thumbnailWidth;
    }

    public void setThumbnailWidth(Integer thumbnailWidth) {
        this.thumbnailWidth = thumbnailWidth;
    }

    public Creative withThumbnailWidth(Integer thumbnailWidth) {
        this.thumbnailWidth = thumbnailWidth;
        return this;
    }

    public Integer getThumbnailHeight() {
        return thumbnailHeight;
    }

    public void setThumbnailHeight(Integer thumbnailHeight) {
        this.thumbnailHeight = thumbnailHeight;
    }

    public Creative withThumbnailHeight(Integer thumbnailHeight) {
        this.thumbnailHeight = thumbnailHeight;
        return this;
    }

    public Boolean isPredeployed() {
        return predeployed;
    }

    public void setPredeployed(Boolean predeployed) {
        this.predeployed = predeployed;
    }

    public Creative withPredeployed(Boolean predeployed) {
        this.predeployed = predeployed;
        return this;
    }

    public CreativePreview getPreview() {
        return preview;
    }

    public void setPreview(CreativePreview preview) {
        this.preview = preview;
    }

    public Creative withPreview(CreativePreview preview) {
        this.preview = preview;
        return this;
    }

    public String getScreenshotUrl() {
        return screenshotUrl;
    }

    public void setScreenshotUrl(String screenshotUrl) {
        this.screenshotUrl = screenshotUrl;
    }

    public Creative withScreenshotUrl(String screenshotUrl) {
        this.screenshotUrl = screenshotUrl;
        return this;
    }

    public CreativeLayoutCode getLayoutCode() {
        return layoutCode;
    }

    public void setLayoutCode(CreativeLayoutCode layoutCode) {
        this.layoutCode = layoutCode;
    }

    public Creative withLayoutCode(CreativeLayoutCode layoutCode) {
        this.layoutCode = layoutCode;
        return this;
    }

    public Integer getLayoutCodeId() {
        return layoutCodeId;
    }

    public void setLayoutCodeId(Integer layoutCodeId) {
        this.layoutCodeId = layoutCodeId;
    }

    public Creative withLayoutCodeId(Integer layoutCodeId) {
        this.layoutCodeId = layoutCodeId;
        return this;
    }

    public Integer getGroupId() {
        return groupId;
    }

    public void setGroupId(Integer groupId) {
        this.groupId = groupId;
    }

    public Creative withGroupId(Integer groupId) {
        this.groupId = groupId;
        return this;
    }

    public BusinessType getBusinessType() {
        return businessType;
    }

    public void setBusinessType(BusinessType businessType) {
        this.businessType = businessType;
    }

    public Creative withBusinessType(BusinessType businessType) {
        this.businessType = businessType;
        return this;
    }

    public List<TnsArticle> getTnsArticles() {
        return tnsArticles;
    }

    public void setTnsArticles(List<TnsArticle> tnsArticles) {
        this.tnsArticles = tnsArticles;
    }

    public Creative withTnsArticles(List<TnsArticle> tnsArticles) {
        this.tnsArticles = tnsArticles;
        return this;
    }

    public List<TnsBrand> getTnsBrands() {
        return tnsBrands;
    }

    public void setTnsBrands(List<TnsBrand> tnsBrands) {
        this.tnsBrands = tnsBrands;
    }

    public Creative withTnsBrands(List<TnsBrand> tnsBrands) {
        this.tnsBrands = tnsBrands;
        return this;
    }

    @Override
    public String toString() {
        return "Creative{" +
                "path='" + path + '\'' +
                ", id=" + id +
                ", templateId=" + templateId +
                ", width=" + width +
                ", height=" + height +
                ", name='" + name + '\'' +
                ", tag='" + tag + '\'' +
                ", note='" + note + '\'' +
                ", expireDate='" + expireDate + '\'' +
                ", parameters=" + parameters +
                ", status=" + status +
                ", version=" + version +
                ", subVersion=" + subVersion +
                ", thumbnailUrl='" + thumbnailUrl + '\'' +
                ", thumbnailWidth=" + thumbnailWidth +
                ", thumbnailHeight=" + thumbnailHeight +
                ", predeployed=" + predeployed +
                ", preview=" + preview +
                ", screenshotUrl='" + screenshotUrl + '\'' +
                ", layoutCode=" + layoutCode +
                ", layoutCodeId=" + layoutCodeId +
                ", groupId=" + groupId +
                ", businessType=" + businessType +
                ", tnsArticles=" + tnsArticles +
                ", tnsBrands=" + tnsBrands +
                '}';
    }
}
