package ru.yandex.direct.bannerstorage.client.model;

/**
 * Дополнительные опции, которые можно запрашивать у bannerstorage при получении информации о креативах
 * Конвертируются в значения query-параметра include через запятую, например, "?include=isPredeployed,previewUrl"
 */
public enum CreativeInclude {
    IS_PREDEPLOYED("isPredeployed"),
    /**
     * URL на актуальное превью креатива
     */
    PREVIEW_URL("previewUrl"),
    LAYOUT_CODE("layoutCode"),
    /**
     * Полная информация о превью (помимо URL, ещё и width, height, и code)
     * Это "тяжёлый" include: его вычисление занимает существенное время, особенно
     * если запрашивается не единичный креатив, а список креативов
     */
    PREVIEW("preview"),
    ;

    private String bannerstorageInclude;

    CreativeInclude(String bannerstorageInclude) {
        this.bannerstorageInclude = bannerstorageInclude;
    }

    public String getBannerstorageInclude() {
        return bannerstorageInclude;
    }
}
