package ru.yandex.direct.bannerstorage.client.model;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
        "paramName",
        "paramType",
        "values",
})
public class Parameter {

    @JsonProperty("paramName")
    private String paramName;
    @JsonProperty("paramType")
    private ParameterType paramType;
    @JsonProperty("values")
    private List<String> values = null;

    public Parameter() {
    }

    public Parameter(Parameter other) {
        this.paramName = other.paramName;
        this.paramType = other.paramType;
        this.values = other.values != null ? new ArrayList<>(other.values) : null;
    }

    @JsonProperty("paramName")
    public String getParamName() {
        return paramName;
    }

    @JsonProperty("paramName")
    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public Parameter withParamName(String paramName) {
        this.paramName = paramName;
        return this;
    }

    @JsonProperty("paramType")
    public ParameterType getParamType() {
        return paramType;
    }

    @JsonProperty("paramType")
    public void setParamType(ParameterType paramType) {
        this.paramType = paramType;
    }

    public Parameter withParamType(ParameterType paramType) {
        this.paramType = paramType;
        return this;
    }

    @JsonProperty("values")
    public List<String> getValues() {
        return values;
    }

    @JsonProperty("values")
    public void setValues(List<String> values) {
        this.values = values;
    }

    public Parameter withValues(List<String> values) {
        this.values = values;
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("paramName", paramName).append("paramType", paramType)
                .append("values", values).toString();
    }
}
