package ru.yandex.direct.bannerstorage.client.model

import com.fasterxml.jackson.annotation.JsonProperty

/**
 * Дополнительные опции, которые можно запрашивать у bannerstorage при получении информации о шаблоне
 * Конвертируются в значения query-параметра include через запятую, например, "?include=parameters,layoutCodes"
 */
enum class TemplateInclude(
    val apiConstant: String
) {
    PARAMETERS("parameters"),
    LAYOUT_CODES("layoutCodes")
}

class LayoutCode(
    @JsonProperty("id") val id: Int,
    @JsonProperty("themeId") val themeId: Int,
    @JsonProperty("layoutId") val layoutId: Int,
    @JsonProperty("sizeId") val sizeId: Int,
)

class Template(
    @JsonProperty("id") val id: Int,
    @JsonProperty("name") val name: String,
    // это поле приезжает только если указан соответствующий include-параметр
    @JsonProperty("layoutCodes") val layoutCodes: List<LayoutCode>?,
    // это поле приезжает только если указан соответствующий include-параметр
    @JsonProperty("parameters") val parameters: List<TemplateParameter>?,
)

class TemplateParameter(
    @JsonProperty("id") val id: Int,
    @JsonProperty("name") val name: String,
    @JsonProperty("typeName") val type: ParameterType,
    @JsonProperty("control") val control: ControlType,
    @JsonProperty("label") val label: String,
    @JsonProperty("description") val description: String,
    @JsonProperty("defaultValue") val defaultValue: String?,
    @JsonProperty("validation") val validation: TemplateParameterValidation,
)

class TemplateParameterValidation(
    /**
     * Минимальное значение числа или минимальная длина строки, для файлов задает минимальный размер файла.
     * Для чисел по умолчанию устанавливается в -0x80000000. Для строк и файлов по умолчанию устанавливается в 0
     */
    @JsonProperty("min") val min: Int?,
    /**
     * Максимальное значение числа или максимальная длина строки, для файлов задает максимальный размер файла.
     * Для чисел по умолчанию устанавливается в +0x7FFFFFFF.
     * Для строк по умолчанию устанавливается в 4000, а для файлов в 30 килобайт
     */
    @JsonProperty("max") val max: Int?,
    /**
     * Максимальное количество строк в тексте
     */
    @JsonProperty("maxLines") val maxLines: Int?,
    /**
     * Список допустимых типов файла. Описание структуры FileTypeInfo есть в главе "Файлы"
     */
    @JsonProperty("fileTypes") val fileTypes: List<TemplateParameterFileType>?,
    /**
     * Список вариантов выбора для типа параметра "select". Предназначено для отображения в комбо-боксах или радио-кнопках
     */
    @JsonProperty("selectItems") val selectItems: List<TemplateParameterSelectItem>?,
    /**
     * Минимальное количество записей в списке 0 <= n < 255
     */
    @JsonProperty("minListLength") val minListLength: Int?,
    /**
     * Максимальное количество записей в списке 0 < n < 255
     */
    @JsonProperty("maxListLength") val maxListLength: Int?,
    /**
     * Минимальная частота кадров
     */
    @JsonProperty("minFrameRate") val minFrameRate: Float?,
    /**
     * Максимальная частота кадров
     */
    @JsonProperty("maxFrameRate") val maxFrameRate: Float?,
    /**
     * Минимальная ширина картинки
     */
    @JsonProperty("minWidth") val minWidth: Int?,
    /**
     * Максимальная ширина картинки
     */
    @JsonProperty("maxWidth") val maxWidth: Int?,
    /**
     * Минимальная высота картинки
     */
    @JsonProperty("minHeight") val minHeight: Int?,
    /**
     * Максимальная высота картинки
     */
    @JsonProperty("maxHeight") val maxHeight: Int?,
    /**
     * Минимальная длительность видео-ролика
     */
    @JsonProperty("minDuration") val minDuration: Int?,
    /**
     * Максимальная длительность видео-ролика
     */
    @JsonProperty("maxDuration") val maxDuration: Int?,
    /**
     * Минимальная скорость потока в байтах в секунду
     */
    @JsonProperty("minBandwidth") val minBandwidth: Int?,
    /**
     * Максимальная скорость потока в байтах в секунду
     */
    @JsonProperty("maxBandwidth") val maxBandwidth: Int?,
)

class TemplateParameterFileType(
    @JsonProperty("id") val id: Int,
    // Тип mime файла
    @JsonProperty("mimeType") val mimeType: String,
    // Расширения файла через запятую. Пример: "jpg,jpeg"
    @JsonProperty("extensions") val extensions: String,
)

class TemplateParameterSelectItem(
    @JsonProperty("name") val name: String,
    @JsonProperty("value") val value: String,
)
