package ru.yandex.direct.bannersystem;

import java.time.Duration;
import java.util.List;
import java.util.UUID;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.bannersystem.container.appstoredata.BsImportAppStoreDataItem;
import ru.yandex.direct.bannersystem.container.appstoredata.BsImportAppStoreDataResponse;
import ru.yandex.direct.bannersystem.container.appstoredata.BsImportAppStoreDataResponseItem;
import ru.yandex.direct.bannersystem.exception.BsClientException;
import ru.yandex.direct.bannersystem.exception.BsImportAppStoreDataException;

/**
 * Клиент для ручки выгрузки таблиц в БК.
 */
@ParametersAreNonnullByDefault
public class BsImportAppStoreDataClient {
    private final BannerSystemClient bannerSystemClient;

    public BsImportAppStoreDataClient(BannerSystemClient bannerSystemClient) {
        this.bannerSystemClient = bannerSystemClient;
    }

    /**
     * Получить из БК таблицу в виде списка объектов, представляющих ее строки.
     */
    public List<BsImportAppStoreDataResponseItem> sendAppStoreData(List<BsImportAppStoreDataItem> data,
                                                                   UUID requestUuid, Duration timeout) {
        BsImportAppStoreDataResponse response;
        try {
            response = bannerSystemClient
                    .doRequest(BsUriFactory.IMPORT_APPLICATION_STORE_DATA, data, requestUuid, timeout);
        } catch (BsClientException e) {
            throw new BsImportAppStoreDataException("Got exception while performing query", e);
        }

        if (response.isUnDone()) {
            throw new BsImportAppStoreDataException("UnDone received in BS response");
        }

        if (response.getError() != null) {
            throw new BsImportAppStoreDataException(
                    String.format("Error received in BS response: %s", response.getErrorMessage()));
        }

        if (response.getProcessedResults() == null) {
            throw new BsImportAppStoreDataException("No result received");
        }

        return response.getProcessedResults();
    }
}
