package ru.yandex.direct.bannersystem.container.appstoredata;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
public class BsImportAppStoreDataIcon {
    @JsonProperty("URL")
    private final String url;
    @JsonProperty("Width")
    private final Integer width;
    @JsonProperty("Height")
    private final Integer height;

    public BsImportAppStoreDataIcon(String url, Integer width, Integer height) {
        this.url = url;
        this.width = width;
        this.height = height;
    }

    public String getUrl() {
        return url;
    }

    public Integer getWidth() {
        return width;
    }

    public Integer getHeight() {
        return height;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BsImportAppStoreDataIcon that = (BsImportAppStoreDataIcon) o;
        return Objects.equals(url, that.url) &&
                Objects.equals(width, that.width) &&
                Objects.equals(height, that.height);
    }

    @Override
    public int hashCode() {
        return Objects.hash(url, width, height);
    }
}
