package ru.yandex.direct.bannersystem.container.appstoredata;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
public class BsImportAppStoreDataItem {
    @JsonProperty("mobile_app_id")
    private Long mobileAppId;
    @JsonProperty("store_app_id")
    private String storeAppId;
    @JsonProperty("store_content_id")
    private String storeContentId;
    @JsonProperty("store_name")
    private String storeName;
    @JsonProperty("name")
    private String name;
    @JsonProperty("store_country")
    private String storeCountry;
    @JsonProperty("os_type")
    private String osType;
    @JsonProperty("app_size_bytes")
    private Long appSizeBytes;

    @JsonProperty("review_count")
    private Long reviewCount;
    @JsonProperty("rating")
    private BigDecimal reviewRating;

    @JsonProperty("is_accessible")
    private Boolean isAccessible;

    @JsonProperty("age_label")
    private String ageLabel;

    @JsonProperty("prices")
    private Map<String, Map<String, BsImportAppStoreDataPrice>> prices;
    @JsonProperty("icon")
    private Map<String, BsImportAppStoreDataIcon> icons;
    @JsonProperty("download_count")
    private String downloadCount;
    @JsonProperty("screenshots")
    private List<Map<String, String>> screens;

    public Map<String, BsImportAppStoreDataIcon> getIcons() {
        return icons;
    }

    public void setIcons(
            @Nullable Map<String, BsImportAppStoreDataIcon> icons) {
        this.icons = icons;
    }

    public Map<String, Map<String, BsImportAppStoreDataPrice>> getPrices() {
        return prices;
    }

    public void setPrices(
            Map<String, Map<String, BsImportAppStoreDataPrice>> prices) {
        this.prices = prices;
    }

    public String getAgeLabel() {
        return ageLabel;
    }

    public void setAgeLabel(String ageLabel) {
        this.ageLabel = ageLabel;
    }

    public Boolean getIsAccessible() {
        return isAccessible;
    }

    public void setIsAccessible(Boolean accessible) {
        isAccessible = accessible;
    }

    public BigDecimal getReviewRating() {
        return reviewRating;
    }

    public void setReviewRating(BigDecimal reviewRating) {
        this.reviewRating = reviewRating;
    }

    public Long getReviewCount() {
        return reviewCount;
    }

    public void setReviewCount(Long reviewCount) {
        this.reviewCount = reviewCount;
    }

    public Long getAppSizeBytes() {
        return appSizeBytes;
    }

    public void setAppSizeBytes(Long appSizeBytes) {
        this.appSizeBytes = appSizeBytes;
    }

    public String getOsType() {
        return osType;
    }

    public void setOsType(String osType) {
        this.osType = osType;
    }

    public String getName() {
        return name;
    }

    public BsImportAppStoreDataItem setName(@Nullable String name) {
        this.name = name;
        return this;
    }

    public String getStoreCountry() {
        return storeCountry;
    }

    public void setStoreCountry(String storeCountry) {
        this.storeCountry = storeCountry;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public String getStoreAppId() {
        return storeAppId;
    }

    public void setStoreAppId(String storeAppId) {
        this.storeAppId = storeAppId;
    }

    public Long getMobileAppId() {
        return mobileAppId;
    }

    public void setMobileAppId(Long mobileAppId) {
        this.mobileAppId = mobileAppId;
    }

    public String getStoreContentId() {
        return storeContentId;
    }

    public void setStoreContentId(String storeContentId) {
        this.storeContentId = storeContentId;
    }

    public String getDownloadCount() {
        return downloadCount;
    }

    public void setDownloadCount(@Nullable String downloadCount) {
        this.downloadCount = downloadCount;
    }

    public List<Map<String, String>> getScreens() {
        return screens;
    }

    public void setScreens(@Nullable List<Map<String, String>> screens) {
        this.screens = screens;
    }
}
