package ru.yandex.direct.bannersystem.container.appstoredata;

import java.math.BigDecimal;
import java.util.Objects;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
public class BsImportAppStoreDataPrice {
    @JsonProperty("price_currency")
    private final Integer currencyIsoCode;
    @JsonProperty("price")
    private final BigDecimal price;

    public BsImportAppStoreDataPrice(BigDecimal price, @Nullable Integer currencyIsoCode) {
        this.currencyIsoCode = currencyIsoCode;
        this.price = price;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public Integer getCurrencyIsoCode() {
        return currencyIsoCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BsImportAppStoreDataPrice that = (BsImportAppStoreDataPrice) o;
        return Objects.equals(currencyIsoCode, that.currencyIsoCode) &&
                Objects.equals(price, that.price);
    }

    @Override
    public int hashCode() {
        return Objects.hash(currencyIsoCode, price);
    }
}
