package ru.yandex.direct.bannersystem.container.appstoredata;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import static ru.yandex.direct.utils.CommonUtils.nvl;

@ParametersAreNonnullByDefault
public class BsImportAppStoreDataResponse {
    @JsonProperty("Result")
    private List<BsImportAppStoreDataResponseItem> processedResults;
    @JsonProperty("UnDone")
    private Integer unDone;
    @JsonProperty("Error")
    private Integer error;
    @JsonProperty("ErrorMessage")
    private String errorMessage;

    public List<BsImportAppStoreDataResponseItem> getProcessedResults() {
        return processedResults;
    }

    public BsImportAppStoreDataResponse withProcessedResults(List<BsImportAppStoreDataResponseItem> processedResults) {
        this.processedResults = processedResults;
        return this;
    }

    public Integer getUnDone() {
        return unDone;
    }

    public boolean isUnDone() {
        return nvl(unDone, 0) == 1;
    }

    public BsImportAppStoreDataResponse withUnDone(Integer unDone) {
        this.unDone = unDone;
        return this;
    }

    public Integer getError() {
        return error;
    }

    public BsImportAppStoreDataResponse withError(Integer error) {
        this.error = error;
        return this;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public BsImportAppStoreDataResponse withErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }
}
