package ru.yandex.direct.bannersystem.container.exporttable;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Описание импортируемой из БК таблицы - ее название и формат получаемых данных.
 */
@ParametersAreNonnullByDefault
public class BsTableSpec<R extends BsTableRecord> {
    private String tableName;
    private Class<R> recordClass;

    public BsTableSpec(String tableName, Class<R> recordClass) {
        this.tableName = tableName;
        this.recordClass = recordClass;
    }

    public String getTableName() {
        return tableName;
    }

    public Class<R> getRecordClass() {
        return recordClass;
    }
}
