package ru.yandex.direct.bannersystem.container.exporttable;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown = true)
public class HolidayInfoRecord extends BsTableRecord {
    public static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(DATE_FORMAT_PATTERN);
    private Date updateTime;
    private final Long regionID;
    private final VirtualWeekdayType virtualWeekday;

    public enum VirtualWeekdayType {
        HOLIDAY(0),
        WORKDAY(1);

        private final int code;

        VirtualWeekdayType(int code) {
            this.code = code;
        }

        public int getCode() {
            return code;
        }

        public static VirtualWeekdayType of(String code) {
            return Integer.valueOf(code).equals(VirtualWeekdayType.HOLIDAY.getCode())
                    ? VirtualWeekdayType.HOLIDAY
                    : VirtualWeekdayType.WORKDAY;
        }
    }

    @JsonCreator
    public HolidayInfoRecord(
            @JsonProperty("UpdateTime") String updateTime,
            @JsonProperty("RegionID") String regionID,
            @JsonProperty("VirtualWeekday") String virtualWeekday) {
        try {
            this.updateTime = DATE_FORMAT.parse(updateTime);
        } catch (ParseException ignore) {
        }

        this.regionID = Long.valueOf(regionID);
        this.virtualWeekday = VirtualWeekdayType.of(virtualWeekday);
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public Long getRegionID() {
        return regionID;
    }

    public VirtualWeekdayType getVirtualWeekday() {
        return virtualWeekday;
    }
}
