package ru.yandex.direct.bannersystem.container.exporttable;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown = true)
public class SspInfoRecord extends BsTableRecord {
    private static final String OPTIONS_DIVIDER_REGEX = ",";
    private static final String PRODUCTION_OPTION = "production";

    private String title;
    private Set<String> options;
    private Long sspId;

    @JsonCreator
    public SspInfoRecord(
            @JsonProperty("Title") String title,
            @JsonProperty("Options") String options,
            @JsonProperty("SSPID") Long sspId
    ) {
        this.title = title;
        this.options = new HashSet<>(Arrays.asList(options.split(OPTIONS_DIVIDER_REGEX)));
        this.sspId = sspId;
    }

    public String getTitle() {
        return title;
    }

    public boolean isProductionPlatform() {
        return options.contains(PRODUCTION_OPTION);
    }

    public Long getSspId() {
        return sspId;
    }
}
