package ru.yandex.direct.bannersystem.container.masterreport

const val BS_SHOWS = "Shows"
const val BS_CLICKS = "Clicks"
const val BS_CONVERSIONS = "GoalsNum"
const val BS_COST_PER_CONVERSION = "AvgGoalsCost"
const val BS_AVG_CPC = "AvgClicksCost"
const val BS_COST = "Cost"
const val BS_CTR = "Ctr"
const val BS_CPM = "CPM"
const val BS_RF = "RF"
const val BS_CONVERSION_RATE = "ConversionPct"
const val BS_INCOME = "GoalsIncome"
const val BS_PROFIT = "GoalsProfit"
const val BS_UNIQ_VIEWERS = "Reach"
const val BS_ROI = "GoalsROI"
const val BS_CRR = "GoalsCrr"
const val BS_BOUNCE_RATIO = "BounceRatio"
const val BS_BOUNCES = "Bounces"
const val BS_SESSION_DEPTH = "SessionDepth"
const val BS_SESSION_NUM = "SessionNum"
const val BS_SESSION_NUM_LIM = "SessionNumLimited"

const val BS_MULTI_GOALS_ATTRIBUTION_TYPE = "MultiGoalsAttributionType"
const val BS_MULTI_GOALS_ID = "MultiGoalsID"
const val BS_MULTI_CONVERSIONS = "MultiGoalsNum"
const val BS_MULTI_GOALS_COST_PER_CONVERSION = "MultiGoalsAvgGoalsCost"
const val BS_MULTI_GOALS_CONVERSION_RATE = "MultiGoalsConversionPct"
const val BS_MULTI_GOALS_INCOME = "MultiGoalsIncome"
const val BS_MULTI_GOALS_ROI = "MultiGoalsROI"
const val BS_MULTI_GOALS_CRR = "MultiGoalsCrr"

enum class MasterReportMetric(
        /**
         * Названия полей в БК, которые нужны для вычисления этой метрики
         */
        vararg val bsNames: String
) {
    SHOWS(BS_SHOWS),
    CLICKS(BS_CLICKS),
    CONVERSIONS(BS_CONVERSIONS),
    COST_PER_CONVERSION(BS_COST_PER_CONVERSION),
    AVG_CPC(BS_AVG_CPC),
    COST(BS_COST),
    CTR(BS_CTR),
    CPM(BS_CPM),
    RF(BS_RF),
    CONVERSION_RATE(BS_CONVERSION_RATE),
    INCOME(BS_INCOME),
    PROFIT(BS_PROFIT),
    UNIQ_VIEWERS(BS_UNIQ_VIEWERS),
    ROI(BS_ROI),
    CRR(BS_CRR),
    BOUNCE_RATIO(BS_BOUNCE_RATIO, BS_BOUNCES),
    DEPTH(BS_SESSION_DEPTH, BS_SESSION_NUM, BS_SESSION_NUM_LIM),
    MULTI_GOALS(
            BS_MULTI_CONVERSIONS,
            BS_MULTI_GOALS_COST_PER_CONVERSION,
            BS_MULTI_GOALS_CONVERSION_RATE,
            BS_MULTI_GOALS_INCOME,
            BS_MULTI_GOALS_ROI,
            BS_MULTI_GOALS_CRR,
    )
    ;
}

fun Set<MasterReportMetric>.hasMultiGoalsMetric() = this.contains(MasterReportMetric.MULTI_GOALS)
