package ru.yandex.direct.bannersystem.container.masterreport;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import ru.yandex.direct.bannersystem.container.masterreport.converter.MasterReportMetricConverter;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class MasterReportRequest {

    public Integer withVat;

    public Integer withPerformanceCoverage;

    public Integer withDiscount;

    public String currency;

    public String dateTo;

    public String dateToA;

    public String dateToB;

    public Set<MasterReportDimension> groupBy = null;

    public String dateFrom;

    public String dateFromA;

    public String dateFromB;

    public String lang;

    public Map<ReportColumn, Map<FilterOperator, ?>> filtersPre;

    @JsonSerialize(converter = MasterReportMetricConverter.class)
    public Set<MasterReportMetric> countableFields = null;

    public MasterReportGroupByDate groupByDate;

    public Integer dontGroupAndFilterZerosForTotals;

    public List<OrderBy> orderBy = null;

    public Limits limits;

    public List<Object> countableFieldsByTargettype = null;

    public List<String> orderIds = null;

    public Map<String, MappingItem> mapping;

    public enum FilterOperator {

        @JsonProperty("eq")
        EQ,

        @JsonProperty("ne")
        NE,

        @JsonProperty("gt")
        GT,

        @JsonProperty("lt")
        LT
    }

    public enum ReportColumn {

        @JsonProperty("AttributionType")
        ATTRIBUTION_TYPE,

        @JsonProperty("MultiGoalsAttributionType")
        MULTI_GOALS_ATTRIBUTION_TYPE,

        @JsonProperty("TargetType")
        TARGET_TYPE,

        @JsonProperty("RegionID")
        REGION_ID,

        @JsonProperty("MultiGoalsID")
        MULTI_GOALS_ID,

        @JsonProperty("bid")
        BID
    }

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
    public static class MappingItem {

        public String by;

        @JsonProperty("default")
        public String itemDefault;

        public String dataType;

        public Map<String, String> map;

        public MappingItem setBy(String by) {
            this.by = by;
            return this;
        }

        public MappingItem setItemDefault(String itemDefault) {
            this.itemDefault = itemDefault;
            return this;
        }

        public MappingItem setDataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public MappingItem setMap(Map<String, String> map) {
            this.map = map;
            return this;
        }
    }

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
    public static class Limits {

        public Integer offset;
        public Integer limit;

        public Limits setOffset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Limits setLimit(Integer limit) {
            this.limit = limit;
            return this;
        }

    }

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
    public static class OrderBy {
        public static final String ASC_ORDER = "asc";
        public static final String DESC_ORDER = "desc";

        public String field;
        public String dir = ASC_ORDER;

        public OrderBy setField(String field) {
            this.field = field;
            return this;
        }

        public OrderBy setDir(String dir) {
            this.dir = dir;
            return this;
        }

    }

    public MasterReportRequest setWithVat(Integer withVat) {
        this.withVat = withVat;
        return this;
    }

    public MasterReportRequest setWithPerformanceCoverage(Integer withPerformanceCoverage) {
        this.withPerformanceCoverage = withPerformanceCoverage;
        return this;
    }

    public MasterReportRequest setWithDiscount(Integer withDiscount) {
        this.withDiscount = withDiscount;
        return this;
    }

    public MasterReportRequest setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public MasterReportRequest setDateTo(String dateTo) {
        this.dateTo = dateTo;
        return this;
    }

    public MasterReportRequest setDateToA(String dateToA) {
        this.dateToA = dateToA;
        return this;
    }

    public MasterReportRequest setDateToB(String dateToB) {
        this.dateToB = dateToB;
        return this;
    }

    public MasterReportRequest setGroupBy(Set<MasterReportDimension> groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    public MasterReportRequest setDateFrom(String dateFrom) {
        this.dateFrom = dateFrom;
        return this;
    }

    public MasterReportRequest setDateFromA(String dateFromA) {
        this.dateFromA = dateFromA;
        return this;
    }

    public MasterReportRequest setDateFromB(String dateFromB) {
        this.dateFromB = dateFromB;
        return this;
    }

    public MasterReportRequest setLang(String lang) {
        this.lang = lang;
        return this;
    }

    public MasterReportRequest setFiltersPre(Map<ReportColumn, Map<FilterOperator, ?>> filtersPre) {
        this.filtersPre = filtersPre;
        return this;
    }

    public MasterReportRequest setMapping(Map<String, MappingItem> mapping) {
        this.mapping = mapping;
        return this;
    }

    public MasterReportRequest setCountableFields(Set<MasterReportMetric> countableFields) {
        this.countableFields = countableFields;
        return this;
    }

    public MasterReportRequest setGroupByDate(MasterReportGroupByDate groupByDate) {
        this.groupByDate = groupByDate;
        return this;
    }

    public MasterReportRequest setDontGroupAndFilterZerosForTotals(Integer dontGroupAndFilterZerosForTotals) {
        this.dontGroupAndFilterZerosForTotals = dontGroupAndFilterZerosForTotals;
        return this;
    }

    public MasterReportRequest setOrderBy(List<OrderBy> orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public MasterReportRequest setLimits(Limits limits) {
        this.limits = limits;
        return this;
    }

    public MasterReportRequest setCountableFieldsByTargettype(List<Object> countableFieldsByTargettype) {
        this.countableFieldsByTargettype = countableFieldsByTargettype;
        return this;
    }

    public MasterReportRequest setOrderIds(List<String> orderIds) {
        this.orderIds = orderIds;
        return this;
    }
}
