package ru.yandex.direct.bannersystem.container.masterreport;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import ru.yandex.direct.bannersystem.container.masterreport.converter.MasterReportResponseDeserializer;

@JsonDeserialize(using = MasterReportResponseDeserializer.class)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MasterReportResponse {

    @JsonProperty("data")
    public List<MasterReportRow> data;

    @JsonProperty("status")
    public Integer status;

    @JsonProperty("error_text")
    public String errorText;

    @JsonProperty("totals")
    public MasterReportRow totals;

    public List<MasterReportRow> getData() {
        return data;
    }

    public MasterReportResponse setData(List<MasterReportRow> data) {
        this.data = data;
        return this;
    }

    public Integer getStatus() {
        return status;
    }

    public MasterReportResponse setStatus(Integer status) {
        this.status = status;
        return this;
    }

    public String getErrorText() {
        return errorText;
    }

    public MasterReportResponse setErrorText(String errorText) {
        this.errorText = errorText;
        return this;
    }

    public MasterReportRow getTotals() {
        return totals;
    }

    public MasterReportResponse setTotals(MasterReportRow totals) {
        this.totals = totals;
        return this;
    }
}
